#extension GL_EXT_gpu_shader4 : enable

attribute vec4 position; 
attribute vec2 texcoord; 

uniform mat4 viewproj; 
uniform mat4 view;
uniform mat4 tview;
uniform float pSize;
uniform vec3 eyePos; 

varying vec2 tc; 
varying float pz; 
varying float expz;
varying float alpha; 
varying vec3 vdir;

float farPlane = 3200.0;
float nearPlane = 1.0;
float exponent = 10.00;
float focalPoint = 0.00; 

void main()
{
	vec4 center = vec4(texcoord.xy-vec2(.5), 0.0, 1.0); 
	float size = 40.0*pSize*(1.0+position.w*20.0);//min(position.w, 1.0);

	vec4 bboard = size*(center.x*tview[0]+center.y*tview[1]);
	vec4 newPos = vec4(bboard.xyz+position.xyz, 1.0);
	gl_Position = viewproj*newPos;

	//dof
	pz = (view*vec4(position.xyz, 1.0)).z;
	pz = ((-pz)-nearPlane)/(farPlane-nearPlane); 
	expz = clamp(pow(abs(pz-focalPoint)*8.0, exponent), 0.0, 1.0);

	// fix tc
	tc = texcoord;//+vec2(0.0, 3.0-position.w);
	tc.y = 1.0-tc.y;///4.0;

	alpha = position.w; 

	vdir = normalize(position.xyz-eyePos);

}


//FRAGMENT
varying vec2 tc;
varying float pz;
varying float expz;  
varying float alpha; 
varying vec3 vdir; 
uniform sampler2D Texture0;   //symbolmap
uniform sampler2D Texture1;   //pre-blurred
uniform samplerCube Texture2;   //screenColor / envmap
uniform sampler2D Texture3; 
uniform float tracks[32]; 
//17: particle intensity


void main() {

	vec4 color = textureCube(Texture2, vdir);//pow(RadialLookup(vdir, 0.0, Texture2), vec4(1.0));
	color = .1*pow(color, vec4(2.2));
	gl_FragColor = vec4(1.0)*(texture2D(Texture0, tc, 0));

	gl_FragColor.rgb *= color.rgb*16.0;
	gl_FragColor.a = vec4(1.0-pz)*.2101250f;


	gl_FragColor = .0060125*clamp(gl_FragColor, vec4(0.0), vec4(4.0));

	//gl_FragColor = .01*color;
	gl_FragColor.a = .50;
}

